﻿using VA.TMP.Integration.VIMT.Vista.Mappers;
using VA.TMP.Integration.VIMT.Vista.StateObject;
using VRM.Integration.Servicebus.Core;
using VA.TMP.Integration.VIMT.Vista.Links;

namespace VA.TMP.Integration.VIMT.Vista.PipelineSteps.GroupMakeAppointment
{
    public class MapProGroupAppointmentRequestStep : FilterBase<MakeGroupAppointmentStateObject>
    {
        public override void Execute(MakeGroupAppointmentStateObject state)
        {
            state.ProEcRequest = new MakeAppointmentMapper().MapMakeAppointmentRequest(state, Side.Provider);
            var siteNum = state.ProEcRequest.VIMTVIASchdMakeApptReqqueryBeanInfo.VIMTVIASchdMakeApptReqproviderInfo.mcs_loginSiteCode;

            if (string.IsNullOrEmpty(state.ProUserDuz))
                state.ProLoginRequest = new LoginMapper().GetLoginRequest(state.UserId, siteNum, state.OrganizationServiceProxy, state.SAMLToken);
            else
                state.ProEcRequest.VIMTVIASchdMakeApptReqqueryBeanInfo.VIMTVIASchdMakeApptReqproviderInfo.mcs_userId = state.ProUserDuz;
        }
    }
}
